/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import org.liquigraph.core.io.ChangelogWriter;
import org.liquigraph.core.io.ConditionPrinter;
import org.liquigraph.core.model.Changeset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangelogFileWriter
implements ChangelogWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangelogFileWriter.class);
    private final ConditionPrinter conditionPrinter;
    private final File outputFile;

    public ChangelogFileWriter(ConditionPrinter conditionPrinter, File outputFile) {
        this.conditionPrinter = conditionPrinter;
        this.outputFile = outputFile;
    }

    @Override
    public void write(Collection<Changeset> changelogsToInsert) {
        try {
            LOGGER.info("About to dry-run Liquigraph. Results in file {}", (Object)this.outputFile.getAbsolutePath());
            Path path = this.outputFile.toPath();
            this.reinitializeFile(path);
            if (changelogsToInsert.isEmpty()) {
                this.writeNothingToPersist(path);
                return;
            }
            for (Changeset changeset : changelogsToInsert) {
                this.writeChangeset(changeset, path);
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void reinitializeFile(Path path) throws IOException {
        Files.deleteIfExists(path);
        Files.createFile(path, new FileAttribute[0]);
    }

    private void writeNothingToPersist(Path path) throws IOException {
        Files.write(path, (Iterable<? extends CharSequence>)Lists.newArrayList((Object[])new String[]{"//Liquigraph: nothing to persist!"}), Charsets.UTF_8, new OpenOption[0]);
    }

    private void writeChangeset(Changeset changeset, Path path) throws IOException {
        Files.write(path, this.conditionPrinter.print(changeset.getPrecondition()), Charsets.UTF_8, StandardOpenOption.APPEND);
        Files.write(path, this.changesetToString(changeset), Charsets.UTF_8, StandardOpenOption.APPEND);
        Files.write(path, this.conditionPrinter.print(changeset.getPostcondition()), Charsets.UTF_8, StandardOpenOption.APPEND);
    }

    private Collection<String> changesetToString(Changeset changeset) {
        ArrayList lines = Lists.newArrayList();
        lines.add(String.format("//Liquigraph changeset[author: %s, id: %s]", changeset.getAuthor(), changeset.getId()));
        lines.add(String.format("//Liquigraph changeset[executionContexts: %s]", this.flatten(changeset.getExecutionsContexts())));
        lines.addAll(changeset.getQueries());
        return lines;
    }

    private String flatten(Collection<String> executionsContexts) {
        if (executionsContexts.isEmpty()) {
            return "none declared";
        }
        return Joiner.on((String)",").join(executionsContexts);
    }
}

