/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.liquigraph.core.io.xml.DomSourceValidator;
import org.liquigraph.core.io.xml.SchemaErrorHandler;
import org.liquigraph.core.io.xml.XmlSchemaValidator;
import org.xml.sax.SAXException;

class ImplicitSchemaValidator
implements DomSourceValidator {
    private final Schema schema = ImplicitSchemaValidator.implicitSchema("/schema/changelog.xsd");

    @Override
    public Collection<String> validate(DOMSource source) throws Exception {
        SchemaErrorHandler errorHandler = new SchemaErrorHandler();
        this.validator(errorHandler).validate(source);
        return errorHandler.getErrors();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Schema implicitSchema(String name) {
        try (InputStream stream = XmlSchemaValidator.class.getResourceAsStream(name);){
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(stream));
            return schema;
        }
        catch (IOException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    private Validator validator(SchemaErrorHandler customErrorHandler) {
        Validator validator = this.schema.newValidator();
        validator.setErrorHandler(customErrorHandler);
        return validator;
    }
}

