/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration.validators;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;

public class MandatoryOptionValidator {
    public Collection<String> validate(ClassLoader classLoader, String masterChangelog) {
        LinkedList<String> errors = new LinkedList<String>();
        errors.addAll(MandatoryOptionValidator.validateMasterChangelog(masterChangelog, classLoader));
        return errors;
    }

    private static Collection<String> validateMasterChangelog(String masterChangelog, ClassLoader classLoader) {
        LinkedList<String> errors = new LinkedList<String>();
        if (masterChangelog == null) {
            errors.add("'masterChangelog' should not be null");
        } else {
            try (InputStream stream = classLoader.getResourceAsStream(masterChangelog);){
                if (stream == null) {
                    errors.add(String.format("'masterChangelog' points to a non-existing location: %s", masterChangelog));
                }
            }
            catch (IOException e) {
                errors.add(String.format("'masterChangelog' read error. Cause: %s", e.getMessage()));
            }
        }
        return errors;
    }
}

