/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration.validators;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.liquigraph.core.configuration.DryRunMode;
import org.liquigraph.core.configuration.ExecutionMode;
import org.liquigraph.core.configuration.RunMode;

public class ExecutionModeValidator {
    public Collection<String> validate(ExecutionMode executionMode) {
        if (executionMode == null || executionMode == RunMode.RUN_MODE) {
            return Collections.emptyList();
        }
        if (!(executionMode instanceof DryRunMode)) {
            throw new IllegalArgumentException("Unknown <executionMode>: " + executionMode);
        }
        return this.validateDryRunMode((DryRunMode)executionMode);
    }

    private Collection<String> validateDryRunMode(DryRunMode dryRunMode) {
        LinkedList<String> errors = new LinkedList<String>();
        File output = dryRunMode.getOutputFile();
        Path outputDirectory = output.toPath().getParent();
        if (!Files.isDirectory(outputDirectory, new LinkOption[0])) {
            errors.add(String.format("<%s> is not a directory", outputDirectory));
        }
        if (!Files.isWritable(outputDirectory)) {
            errors.add(String.format("The directory <%s> must be writable", outputDirectory));
        }
        return errors;
    }
}

