/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.api;

import com.google.common.annotations.VisibleForTesting;
import org.liquigraph.core.api.ChangelogDiffMaker;
import org.liquigraph.core.api.MigrationRunner;
import org.liquigraph.core.configuration.Configuration;
import org.liquigraph.core.io.ChangelogGraphReader;
import org.liquigraph.core.io.ConditionExecutor;
import org.liquigraph.core.io.ConditionPrinter;
import org.liquigraph.core.io.GraphJdbcConnector;
import org.liquigraph.core.io.LiquigraphJdbcConnector;
import org.liquigraph.core.io.xml.ChangelogParser;
import org.liquigraph.core.io.xml.ChangelogPreprocessor;
import org.liquigraph.core.io.xml.ImportResolver;
import org.liquigraph.core.io.xml.XmlSchemaValidator;
import org.liquigraph.core.validation.PersistedChangesetValidator;

public final class Liquigraph {
    private final MigrationRunner migrationRunner;

    public Liquigraph() {
        this(new GraphJdbcConnector());
    }

    @VisibleForTesting
    Liquigraph(LiquigraphJdbcConnector connector) {
        this.migrationRunner = new MigrationRunner(connector, new ChangelogParser(new XmlSchemaValidator(), new ChangelogPreprocessor(new ImportResolver())), new ChangelogGraphReader(), new ChangelogDiffMaker(), new ConditionExecutor(), new ConditionPrinter(), new PersistedChangesetValidator());
    }

    public void runMigrations(Configuration configuration) {
        this.migrationRunner.runMigrations(configuration);
    }
}

