/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.model.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.liquigraph.core.model.Changeset;

public class ChangesetById
implements Predicate<Changeset> {
    private final String id;
    private final String author;

    private ChangesetById(String id, String author) {
        this.id = id;
        this.author = author;
        Preconditions.checkState((id != null ? 1 : 0) != 0);
        Preconditions.checkState((author != null ? 1 : 0) != 0);
    }

    public static Predicate<Changeset> BY_ID(String id, String author) {
        return new ChangesetById(id, author);
    }

    public boolean apply(Changeset input) {
        return this.id.equals(input.getId()) && this.author.equals(input.getAuthor());
    }
}

