/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.model;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.liquigraph.core.model.AndQuery;
import org.liquigraph.core.model.CompoundQueries;
import org.liquigraph.core.model.CompoundQuery;
import org.liquigraph.core.model.Query;
import org.liquigraph.core.model.SimpleQuery;

@XmlSeeAlso(value={Query.class})
@XmlRootElement(name="or")
public class OrQuery
implements CompoundQuery {
    private List<Query> queries = Lists.newArrayList();

    @XmlElementRefs(value={@XmlElementRef(name="and", type=AndQuery.class), @XmlElementRef(name="or", type=OrQuery.class), @XmlElementRef(name="query", type=SimpleQuery.class)})
    public List<Query> getQueries() {
        return this.queries;
    }

    public void setQueries(List<Query> queries) {
        this.queries = queries;
    }

    @Override
    public Query getFirstQuery() {
        CompoundQueries.checkQueryListState(this.queries);
        return this.queries.get(0);
    }

    @Override
    public Query getSecondQuery() {
        CompoundQueries.checkQueryListState(this.queries);
        return this.queries.get(1);
    }

    @Override
    public boolean compose(boolean firstResult, boolean secondResult) {
        return firstResult || secondResult;
    }

    @Override
    public String compose(String firstQuery, String secondQuery) {
        return String.format("((%s) OR (%s))", firstQuery, secondQuery);
    }

    public int hashCode() {
        return Objects.hash(this.queries);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OrQuery other = (OrQuery)obj;
        return Objects.equals(this.queries, other.queries);
    }

    public String toString() {
        return String.format("<%s> OR <%s>", this.getFirstQuery(), this.getSecondQuery());
    }
}

