/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io.xml;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.liquigraph.core.io.xml.ChangelogParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class SchemaErrorHandler
implements ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangelogParser.class);
    private final ImmutableList.Builder<String> errors = ImmutableList.builder();

    SchemaErrorHandler() {
    }

    public Collection<String> getErrors() {
        return this.errors.build();
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        LOGGER.warn("XSD validation warning : {}", (Object)exception.getMessage());
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        LOGGER.error("XSD validation error : {}", (Object)exception.getMessage());
        this.errors.add((Object)exception.getMessage());
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        LOGGER.error("XSD validation fatal : {}", (Object)exception.getMessage());
        this.errors.add((Object)exception.getMessage());
    }
}

