/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.liquigraph.core.model.CompoundQuery;
import org.liquigraph.core.model.Condition;
import org.liquigraph.core.model.Precondition;
import org.liquigraph.core.model.Query;
import org.liquigraph.core.model.SimpleQuery;

public class ConditionPrinter {
    public Collection<String> print(Precondition precondition) {
        if (precondition == null) {
            return Lists.newArrayList();
        }
        ArrayList lines = Lists.newArrayList();
        lines.add(String.format("//Liquigraph precondition[if-not-met: %s]", new Object[]{precondition.getPolicy()}));
        lines.addAll(this.print((Condition)precondition));
        return lines;
    }

    public Collection<String> print(Condition precondition) {
        if (precondition == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new String[]{this.traverseQuery(precondition.getQuery())});
    }

    private String traverseQuery(Query query) {
        if (query instanceof SimpleQuery) {
            return ((SimpleQuery)query).getQuery();
        }
        if (query instanceof CompoundQuery) {
            CompoundQuery compoundQuery = (CompoundQuery)query;
            return compoundQuery.compose(this.traverseQuery(compoundQuery.getFirstQuery()), this.traverseQuery(compoundQuery.getSecondQuery()));
        }
        throw new IllegalArgumentException(String.format("Unsupported query type <%s>", query.getClass().getName()));
    }
}

