/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.api;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import org.liquigraph.core.api.ChangelogDiffMaker;
import org.liquigraph.core.configuration.Configuration;
import org.liquigraph.core.io.ChangelogGraphReader;
import org.liquigraph.core.io.ChangelogWriter;
import org.liquigraph.core.io.ConditionExecutor;
import org.liquigraph.core.io.ConditionPrinter;
import org.liquigraph.core.io.LiquigraphJdbcConnector;
import org.liquigraph.core.io.xml.ChangelogParser;
import org.liquigraph.core.model.Changeset;
import org.liquigraph.core.validation.PersistedChangesetValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MigrationRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationRunner.class);
    private final LiquigraphJdbcConnector connector;
    private final ChangelogParser changelogParser;
    private final ChangelogGraphReader changelogReader;
    private final ChangelogDiffMaker changelogDiffMaker;
    private final ConditionExecutor conditionExecutor;
    private final ConditionPrinter conditionPrinter;
    private final PersistedChangesetValidator persistedChangesetValidator;

    public MigrationRunner(LiquigraphJdbcConnector connector, ChangelogParser changelogParser, ChangelogGraphReader changelogGraphReader, ChangelogDiffMaker changelogDiffMaker, ConditionExecutor conditionExecutor, ConditionPrinter conditionPrinter, PersistedChangesetValidator persistedChangesetValidator) {
        this.connector = connector;
        this.changelogParser = changelogParser;
        this.changelogReader = changelogGraphReader;
        this.changelogDiffMaker = changelogDiffMaker;
        this.conditionExecutor = conditionExecutor;
        this.conditionPrinter = conditionPrinter;
        this.persistedChangesetValidator = persistedChangesetValidator;
    }

    public void runMigrations(Configuration configuration) {
        Collection<Changeset> declaredChangesets = this.parseChangesets(configuration.classLoader(), configuration.masterChangelog());
        ConnectionSupplier connectionSupplier = new ConnectionSupplier(configuration);
        try (Connection writeConnection = (Connection)connectionSupplier.get();){
            Collection<Changeset> persistedChangesets = this.readPersistedChangesets(declaredChangesets, writeConnection);
            Collection<Changeset> changelog = this.changelogDiffMaker.computeChangesetsToInsert(configuration.executionContexts(), declaredChangesets, persistedChangesets);
            this.writeApplicableChangesets(configuration, writeConnection, connectionSupplier, changelog);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private Collection<Changeset> parseChangesets(ClassLoader classLoader, String masterChangelog) {
        return this.changelogParser.parse(classLoader, masterChangelog);
    }

    private Collection<Changeset> readPersistedChangesets(Collection<Changeset> declaredChangesets, Connection writeConnection) {
        Collection<Changeset> persistedChangesets = this.changelogReader.read(writeConnection);
        Collection<String> errors = this.persistedChangesetValidator.validate(declaredChangesets, persistedChangesets);
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(this.formatErrorMessage(errors));
        }
        return persistedChangesets;
    }

    private void writeApplicableChangesets(Configuration configuration, Connection writeConnection, Supplier<Connection> connectionSupplier, Collection<Changeset> changelogsToInsert) {
        ChangelogWriter changelogWriter = configuration.resolveWriter(writeConnection, connectionSupplier, this.conditionExecutor, this.conditionPrinter);
        changelogWriter.write(changelogsToInsert);
    }

    private String formatErrorMessage(Collection<String> errors) {
        String separator = "\n\t";
        return separator + Joiner.on((String)separator).join(errors);
    }

    private class ConnectionSupplier
    implements Supplier<Connection> {
        private final Configuration configuration;

        public ConnectionSupplier(Configuration configuration) {
            this.configuration = configuration;
        }

        public Connection get() {
            return MigrationRunner.this.connector.connect(this.configuration);
        }
    }
}

