/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io.xml;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

class RedirectAwareEntityResolver
implements EntityResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedirectAwareEntityResolver.class);
    private static final int MAX_REDIRECT_COUNT = 10;

    RedirectAwareEntityResolver() {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        URL url = new URL(systemId);
        HttpURLConnection connection = this.openConnection(url, 0);
        return new InputSource(connection.getInputStream());
    }

    private HttpURLConnection openConnection(URL url, int redirectCount) throws IOException {
        if (redirectCount == 10) {
            throw new RuntimeException(String.format("Already followed %d redirect(s), stopping now", 10));
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (this.isRedirect(connection.getResponseCode())) {
            String location = connection.getHeaderField("Location");
            LOGGER.debug("Following redirect from {} to {}", (Object)url.toExternalForm(), (Object)location);
            return this.openConnection(new URL(location), redirectCount + 1);
        }
        return connection;
    }

    private boolean isRedirect(int status) {
        return status == 302 || status == 301 || status == 303;
    }
}

