/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io.lock;

import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import org.liquigraph.core.exception.LiquigraphLockException;
import org.liquigraph.core.io.lock.ShutdownTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiquigraphLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(LiquigraphLock.class);
    private final UUID uuid = UUID.randomUUID();
    private final Set<Connection> connections = Sets.newIdentityHashSet();
    private final Thread task = new Thread(new ShutdownTask(this));

    void acquire(Connection connection) {
        if (this.addConnection(connection)) {
            this.addShutdownHook();
            this.ensureLockUniqueness(connection);
            this.tryWriteLock(connection);
        }
    }

    void release(Connection connection) {
        if (this.removeConnection(connection)) {
            this.removeShutdownHook();
            this.releaseLock(connection);
        }
    }

    void release() {
        for (Connection connection : new ArrayList<Connection>(this.connections)) {
            this.release(connection);
        }
    }

    private boolean addConnection(Connection connection) {
        boolean wasEmpty = this.connections.isEmpty();
        this.connections.add(connection);
        return wasEmpty;
    }

    private boolean removeConnection(Connection connection) {
        if (this.connections.isEmpty()) {
            return false;
        }
        this.connections.remove(connection);
        return this.connections.isEmpty();
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(this.task);
    }

    private void removeShutdownHook() {
        Runtime.getRuntime().removeShutdownHook(this.task);
    }

    private void ensureLockUniqueness(Connection connection) {
        try (Statement statement = connection.createStatement();){
            statement.execute("CREATE CONSTRAINT ON (lock:__LiquigraphLock) ASSERT lock.name IS UNIQUE");
            connection.commit();
        }
        catch (SQLException e) {
            throw new LiquigraphLockException("Could not ensure __LiquigraphLock uniqueness\n\tPlease make sure your instance is in a clean state\n\tNo more than 1 lock should be there simultaneously!", e);
        }
    }

    private void tryWriteLock(Connection connection) {
        try (PreparedStatement statement = connection.prepareStatement("CREATE (:__LiquigraphLock {name:'John', uuid:{1}})");){
            statement.setString(1, this.uuid.toString());
            statement.execute();
            connection.commit();
        }
        catch (SQLException e) {
            throw new LiquigraphLockException("Cannot create __LiquigraphLock lock\n\tLikely another Liquigraph execution is going on or has crashed.", e);
        }
    }

    private void releaseLock(Connection connection) {
        try (PreparedStatement statement = connection.prepareStatement("MATCH (lock:__LiquigraphLock {uuid:{1}}) DELETE lock");){
            statement.setString(1, this.uuid.toString());
            statement.execute();
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Cannot remove __LiquigraphLock during cleanup.", (Throwable)e);
        }
    }
}

