/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.liquigraph.core.exception.PreconditionNotMetException;
import org.liquigraph.core.io.ChangelogWriter;
import org.liquigraph.core.io.ConditionExecutor;
import org.liquigraph.core.model.Changeset;
import org.liquigraph.core.model.Condition;
import org.liquigraph.core.model.Postcondition;
import org.liquigraph.core.model.Precondition;

public class ChangelogGraphWriter
implements ChangelogWriter {
    private static final String CHANGESET_UPSERT = "MERGE (changelog:__LiquigraphChangelog) MERGE (changelog)<-[ewc:EXECUTED_WITHIN_CHANGELOG]-(changeset:__LiquigraphChangeset {id: {1}, author: {3}}) ON MATCH SET  changeset.checksum = {2} ON CREATE SET changeset.checksum = {2},               ewc.time = timestamp() WITH changeset OPTIONAL MATCH (changeset)<-[eq:EXECUTED_WITHIN_CHANGESET]-(query:__LiquigraphQuery) DELETE eq, query RETURN changeset ";
    private static final String QUERY_UPSERT = "MATCH (changeset:__LiquigraphChangeset {id: {1}, author: {2}}) CREATE (changeset)<-[:EXECUTED_WITHIN_CHANGESET {`order`:{3}}]-(:__LiquigraphQuery {query: {4}})";
    private static final boolean NO_PRECONDITION = true;
    private static final boolean NO_POSTCONDITION = false;
    private final Connection writeConnection;
    private final Supplier<Connection> connectionSupplier;
    private final ConditionExecutor conditionExecutor;

    public ChangelogGraphWriter(Connection writeConnection, Supplier<Connection> connectionSupplier, ConditionExecutor conditionExecutor) {
        this.writeConnection = writeConnection;
        this.connectionSupplier = connectionSupplier;
        this.conditionExecutor = conditionExecutor;
    }

    @Override
    public void write(Collection<Changeset> changelog) {
        for (Changeset changeset : changelog) {
            StatementExecution statementExecution = this.executeStatement(changeset);
            if (statementExecution == StatementExecution.IGNORE_FAILURE) continue;
            this.insertChangeset(changeset);
        }
    }

    private StatementExecution executeStatement(Changeset changeset) {
        try {
            boolean postcondition;
            Precondition precondition = changeset.getPrecondition();
            boolean preconditionResult = this.executePrecondition(precondition);
            if (!preconditionResult) {
                return ChangelogGraphWriter.handleFailedPrecondition(precondition, changeset);
            }
            do {
                try (Statement statement = this.writeConnection.createStatement();){
                    for (String query : changeset.getQueries()) {
                        statement.execute(query);
                    }
                    this.writeConnection.commit();
                }
            } while (postcondition = this.executePostcondition(changeset.getPostcondition()));
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return StatementExecution.SUCCESS;
    }

    private boolean executePrecondition(Precondition precondition) {
        if (precondition == null) {
            return true;
        }
        return this.executeCondition(precondition);
    }

    private static StatementExecution handleFailedPrecondition(Precondition precondition, Changeset changeset) {
        switch (precondition.getPolicy()) {
            case MARK_AS_EXECUTED: {
                return StatementExecution.SUCCESS;
            }
            case CONTINUE: {
                return StatementExecution.IGNORE_FAILURE;
            }
            case FAIL: {
                throw new PreconditionNotMetException(String.format("Changeset id=<%s>, author=<%s>: precondition query %s failed with policy <%s>. Aborting.", new Object[]{changeset.getId(), changeset.getAuthor(), precondition.getQuery(), precondition.getPolicy()}));
            }
        }
        throw new IllegalArgumentException(String.format("Changeset id=<%s>, author=<%s>: unsupported policy <%s>. Aborting.", new Object[]{changeset.getId(), changeset.getAuthor(), precondition.getPolicy()}));
    }

    private boolean executePostcondition(Postcondition postcondition) {
        if (postcondition == null) {
            return false;
        }
        return this.executeCondition(postcondition);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean executeCondition(Condition condition) {
        try (Connection readConnection = (Connection)this.connectionSupplier.get();){
            boolean conditionResult = this.conditionExecutor.executeCondition(readConnection, condition);
            readConnection.rollback();
            boolean bl = conditionResult;
            return bl;
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void insertChangeset(Changeset changeset) {
        try (PreparedStatement changesetStmt = this.writeConnection.prepareStatement(CHANGESET_UPSERT);
             PreparedStatement queryStmt = this.writeConnection.prepareStatement(QUERY_UPSERT);){
            this.insertChangesetNode(changeset, changesetStmt);
            this.insertQueryNodes(changeset, queryStmt);
            this.writeConnection.commit();
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void insertChangesetNode(Changeset changeset, PreparedStatement changesetStmt) throws SQLException {
        this.populateChangesetStatement(changeset, changesetStmt);
        changesetStmt.execute();
    }

    private void insertQueryNodes(Changeset changeset, PreparedStatement queryStmt) throws SQLException {
        queryStmt.setString(1, changeset.getId());
        queryStmt.setString(2, changeset.getAuthor());
        Collection<String> queries = changeset.getQueries();
        for (int i = 0; i < queries.size(); ++i) {
            queryStmt.setInt(3, i);
            queryStmt.setString(4, (String)Iterables.get(queries, (int)i));
            queryStmt.execute();
        }
    }

    private void populateChangesetStatement(Changeset changeset, PreparedStatement changesetStmt) throws SQLException {
        for (Integer key : this.changesetParameters(changeset).keySet()) {
            changesetStmt.setObject(key, this.changesetParameters(changeset).get(key));
        }
    }

    private Map<Integer, Object> changesetParameters(Changeset changeset) {
        String checksum = changeset.getChecksum();
        HashMap<Integer, Object> parameters = new HashMap<Integer, Object>();
        parameters.put(1, changeset.getId());
        parameters.put(2, checksum);
        parameters.put(3, changeset.getAuthor());
        return parameters;
    }

    private static enum StatementExecution {
        SUCCESS,
        IGNORE_FAILURE;

    }
}

