/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration.validators;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.neo4j.graphdb.GraphDatabaseService;

public class ConnectionConfigurationValidator {
    public Collection<String> validate(Optional<String> uri, Optional<DataSource> dataSource, Optional<GraphDatabaseService> database) {
        if (Iterables.size((Iterable)Optional.presentInstances(Arrays.asList(uri, dataSource, database))) != 1) {
            return ImmutableList.of((Object)"Exactly one of JDBC URI, JDBC DataSource or GraphDatabaseService needs to be configured");
        }
        if (uri.isPresent()) {
            return ConnectionConfigurationValidator.validateConnectionString((String)uri.get());
        }
        return Collections.emptyList();
    }

    private static Collection<String> validateConnectionString(String uri) {
        LinkedList<String> errors = new LinkedList<String>();
        if (!uri.startsWith("jdbc:neo4j:")) {
            errors.add(String.format("Invalid JDBC URI. Supported configurations:\n\t - jdbc:neo4j://<host>:<port>/\n\t - jdbc:neo4j:file:/path/to/db\n\t - jdbc:neo4j:mem or jdbc:neo4j:mem:name.\nGiven: %s", uri));
        }
        return errors;
    }
}

