/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Collection;
import org.liquigraph.core.model.predicates.ExecutionContextsMatchAnyContext;

public class ExecutionContexts {
    public static final ExecutionContexts DEFAULT_CONTEXT = new ExecutionContexts((Optional<Collection<String>>)Optional.absent());
    private Predicate<String> anyContext;

    public ExecutionContexts(Collection<String> executionContexts) {
        this((Optional<Collection<String>>)Optional.fromNullable(executionContexts));
    }

    private ExecutionContexts(Optional<Collection<String>> contexts) {
        this.anyContext = ExecutionContextsMatchAnyContext.BY_ANY_CONTEXT(contexts);
    }

    public boolean matches(Optional<Collection<String>> declaredContexts) {
        if (!declaredContexts.isPresent()) {
            return true;
        }
        Collection changesetContexts = (Collection)declaredContexts.get();
        if (changesetContexts.isEmpty()) {
            return true;
        }
        return FluentIterable.from((Iterable)changesetContexts).anyMatch(this.anyContext);
    }
}

