/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.liquigraph.core.configuration.ConnectionConfiguration;

public class ConnectionConfigurationByUri
implements ConnectionConfiguration {
    private final String uri;
    private final Optional<String> username;
    private final Optional<String> password;
    private final Function<String, Connection> driverManager;

    public ConnectionConfigurationByUri(String uri, Optional<String> username, Optional<String> password) {
        this(uri, username, password, UriToConnectionFunction.INSTANCE);
    }

    @VisibleForTesting
    ConnectionConfigurationByUri(String uri, Optional<String> username, Optional<String> password, Function<String, Connection> driverManager) {
        this.uri = uri;
        this.username = username;
        this.password = password;
        this.driverManager = driverManager;
    }

    public Connection get() {
        return (Connection)this.driverManager.apply((Object)this.uri());
    }

    private String uri() {
        if (!this.username.isPresent()) {
            return this.uri;
        }
        return this.authenticatedUri();
    }

    private String authenticatedUri() {
        String firstDelimiter = this.uri.contains("?") ? "," : "?";
        return this.uri + firstDelimiter + "user=" + (String)this.username.get() + ",password=" + (String)this.password.or((Object)"");
    }

    private static enum UriToConnectionFunction implements Function<String, Connection>
    {
        INSTANCE;


        public Connection apply(String uri) {
            try {
                return DriverManager.getConnection(uri);
            }
            catch (SQLException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

