/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration;

import com.google.common.base.Throwables;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.UUID;
import org.liquigraph.core.configuration.ConnectionConfiguration;
import org.neo4j.graphdb.GraphDatabaseService;

class ConnectionConfigurationByGraphDatabaseService
implements ConnectionConfiguration {
    private final String connectionUri;
    private final Properties driverProperties;

    public ConnectionConfigurationByGraphDatabaseService(GraphDatabaseService graphDatabaseService) {
        String databaseName = this.generateUniqueDatabaseName();
        this.connectionUri = this.createConnectionUri(databaseName);
        this.driverProperties = new Properties();
        this.driverProperties.put(databaseName, graphDatabaseService);
    }

    private String generateUniqueDatabaseName() {
        return UUID.randomUUID().toString();
    }

    private String createConnectionUri(String databaseName) {
        return String.format("jdbc:neo4j:instance:%s", databaseName);
    }

    public Connection get() {
        return this.getConnection(this.connectionUri, this.driverProperties);
    }

    protected Connection getConnection(String uri, Properties driverProperties) {
        try {
            return DriverManager.getConnection(uri, driverProperties);
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

