/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.liquigraph.core.configuration.ConnectionConfiguration;

public class ConnectionConfigurationByDataSource
implements ConnectionConfiguration {
    private final DataSource dataSource;
    private final Optional<String> username;
    private final Optional<String> password;

    public ConnectionConfigurationByDataSource(DataSource dataSource, Optional<String> username, Optional<String> password) {
        this.dataSource = dataSource;
        this.username = username;
        this.password = password;
    }

    public Connection get() {
        try {
            return this.connection();
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Connection connection() throws SQLException {
        if (!this.username.isPresent()) {
            return this.dataSource.getConnection();
        }
        return this.dataSource.getConnection((String)this.username.get(), (String)this.password.or((Object)""));
    }
}

