/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.liquigraph.core.configuration.Configuration;
import org.liquigraph.core.configuration.ConnectionConfiguration;
import org.liquigraph.core.configuration.ConnectionConfigurationByDataSource;
import org.liquigraph.core.configuration.ConnectionConfigurationByGraphDatabaseService;
import org.liquigraph.core.configuration.ConnectionConfigurationByUri;
import org.liquigraph.core.configuration.DryRunMode;
import org.liquigraph.core.configuration.ExecutionContexts;
import org.liquigraph.core.configuration.ExecutionMode;
import org.liquigraph.core.configuration.RunMode;
import org.liquigraph.core.configuration.validators.ConnectionConfigurationValidator;
import org.liquigraph.core.configuration.validators.ExecutionModeValidator;
import org.liquigraph.core.configuration.validators.MandatoryOptionValidator;
import org.liquigraph.core.configuration.validators.UserCredentialsOptionValidator;
import org.liquigraph.core.io.xml.ChangelogLoader;
import org.liquigraph.core.io.xml.ClassLoaderChangelogLoader;
import org.neo4j.graphdb.GraphDatabaseService;
import org.restlet.engine.Engine;

public final class ConfigurationBuilder {
    private String masterChangelog;
    private Optional<DataSource> dataSource = Optional.absent();
    private Optional<String> uri = Optional.absent();
    private Optional<GraphDatabaseService> database = Optional.absent();
    private Optional<String> username = Optional.absent();
    private Optional<String> password = Optional.absent();
    private ExecutionContexts executionContexts = ExecutionContexts.DEFAULT_CONTEXT;
    private ExecutionMode executionMode;
    private MandatoryOptionValidator mandatoryOptionValidator = new MandatoryOptionValidator();
    private ConnectionConfigurationValidator datasourceConnectionValidator = new ConnectionConfigurationValidator();
    private ExecutionModeValidator executionModeValidator = new ExecutionModeValidator();
    private UserCredentialsOptionValidator userCredentialsOptionValidator = new UserCredentialsOptionValidator();
    private ChangelogLoader changelogLoader = ClassLoaderChangelogLoader.currentThreadContextClassLoader();

    public ConfigurationBuilder withMasterChangelogLocation(String masterChangelog) {
        this.masterChangelog = masterChangelog;
        return this;
    }

    public ConfigurationBuilder withUri(String uri) {
        this.uri = Optional.fromNullable((Object)uri);
        return this;
    }

    public ConfigurationBuilder withDataSource(DataSource dataSource) {
        this.dataSource = Optional.fromNullable((Object)dataSource);
        return this;
    }

    public ConfigurationBuilder withGraphDatabaseService(GraphDatabaseService database) {
        this.database = Optional.fromNullable((Object)database);
        return this;
    }

    public ConfigurationBuilder withUsername(String username) {
        this.username = Optional.fromNullable((Object)username);
        return this;
    }

    public ConfigurationBuilder withPassword(String password) {
        this.password = Optional.fromNullable((Object)password);
        return this;
    }

    public ConfigurationBuilder withExecutionContexts(String ... executionContexts) {
        return this.withExecutionContexts(Lists.newArrayList((Object[])executionContexts));
    }

    public ConfigurationBuilder withExecutionContexts(Collection<String> executionContexts) {
        if (!executionContexts.isEmpty()) {
            this.executionContexts = new ExecutionContexts(executionContexts);
        }
        return this;
    }

    public ConfigurationBuilder withRunMode() {
        this.executionMode = RunMode.RUN_MODE;
        return this;
    }

    public ConfigurationBuilder withDryRunMode(Path outputDirectory) {
        this.executionMode = new DryRunMode(outputDirectory);
        return this;
    }

    @Deprecated
    public ConfigurationBuilder withClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.changelogLoader = new ClassLoaderChangelogLoader(classLoader);
        }
        return this;
    }

    public ConfigurationBuilder withChangelogLoader(ChangelogLoader changelogLoader) {
        if (changelogLoader != null) {
            this.changelogLoader = changelogLoader;
        }
        return this;
    }

    public Configuration build() {
        LinkedList errors = Lists.newLinkedList();
        errors.addAll(this.mandatoryOptionValidator.validate(this.changelogLoader, this.masterChangelog));
        errors.addAll(this.datasourceConnectionValidator.validate(this.uri, this.dataSource, this.database));
        errors.addAll(this.executionModeValidator.validate(this.executionMode));
        errors.addAll(this.userCredentialsOptionValidator.validate((String)this.username.orNull(), (String)this.password.orNull()));
        if (!errors.isEmpty()) {
            throw new RuntimeException(this.formatErrors(errors));
        }
        this.muteRestletLogs();
        return new Configuration(this.changelogLoader, this.masterChangelog, this.dataSourceConfiguration(), this.executionContexts, this.executionMode);
    }

    private ConnectionConfiguration dataSourceConfiguration() {
        if (this.uri.isPresent()) {
            return new ConnectionConfigurationByUri((String)this.uri.get(), this.username, this.password);
        }
        if (this.database.isPresent()) {
            return new ConnectionConfigurationByGraphDatabaseService((GraphDatabaseService)this.database.get());
        }
        return new ConnectionConfigurationByDataSource((DataSource)this.dataSource.get(), this.username, this.password);
    }

    private void muteRestletLogs() {
        Engine.setRestletLogLevel((Level)Level.SEVERE);
    }

    private String formatErrors(Collection<String> errors) {
        String separator = "\n\t - ";
        return String.format("%s%s", separator, Joiner.on((String)separator).join(errors));
    }
}

