/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.validation;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import org.liquigraph.core.model.Changeset;
import org.liquigraph.core.model.predicates.ChangesetById;
import org.liquigraph.core.model.predicates.ChangesetRunOnChange;

public class PersistedChangesetValidator {
    public Collection<String> validate(Collection<Changeset> declaredChangesets, Collection<Changeset> persistedChangesets) {
        Collection changesets = Collections2.filter(declaredChangesets, (Predicate)Predicates.not((Predicate)ChangesetRunOnChange.RUN_ON_CHANGE));
        return this.validateChecksums(changesets, persistedChangesets);
    }

    private Collection<String> validateChecksums(Collection<Changeset> declaredChangesets, Collection<Changeset> persistedChangesets) {
        LinkedList errors = Lists.newLinkedList();
        for (Changeset declaredChangeset : declaredChangesets) {
            Optional maybePersistedChangeset = FluentIterable.from(persistedChangesets).firstMatch(ChangesetById.BY_ID(declaredChangeset.getId(), declaredChangeset.getAuthor()));
            if (!maybePersistedChangeset.isPresent()) continue;
            Changeset persistedChangeset = (Changeset)maybePersistedChangeset.get();
            String declaredChecksum = declaredChangeset.getChecksum();
            String persistedChecksum = persistedChangeset.getChecksum();
            if (persistedChecksum.equals(declaredChecksum)) continue;
            errors.add(this.checksumMismatchError(declaredChangeset, persistedChangeset));
        }
        return errors;
    }

    private String checksumMismatchError(Changeset declaredChangeset, Changeset persistedChangeset) {
        return String.format("Changeset with ID <%s> and author <%s> has conflicted checksums.%n\t - Declared: <%s>%n\t - Persisted: <%s>.", declaredChangeset.getId(), declaredChangeset.getAuthor(), declaredChangeset.getChecksum(), persistedChangeset.getChecksum());
    }
}

