/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.model.predicates;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Collection;
import org.liquigraph.core.model.Changeset;
import org.liquigraph.core.model.predicates.ChangesetById;

public class ChangesetChecksumHasChanged
implements Predicate<Changeset> {
    private final Collection<Changeset> persistedChangesets;

    private ChangesetChecksumHasChanged(Collection<Changeset> persistedChangesets) {
        this.persistedChangesets = persistedChangesets;
    }

    public static Predicate<Changeset> CHECKSUM_HAS_CHANGED(Collection<Changeset> persistedChangesets) {
        return new ChangesetChecksumHasChanged(persistedChangesets);
    }

    public boolean apply(Changeset input) {
        Optional persistedChangeset = FluentIterable.from(this.persistedChangesets).firstMatch(ChangesetById.BY_ID(input.getId(), input.getAuthor()));
        return persistedChangeset.isPresent() && !input.getChecksum().equals(((Changeset)persistedChangeset.get()).getChecksum());
    }
}

