/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.validation;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import org.liquigraph.core.model.Changeset;
import org.liquigraph.core.model.predicates.ChangesetById;
import org.liquigraph.core.model.predicates.ChangesetRunOnChange;

public class PersistedChangesetValidator {
    public Collection<String> validate(Collection<Changeset> declaredChangesets, Collection<Changeset> persistedChangesets) {
        LinkedList errors = Lists.newLinkedList();
        errors.addAll(this.validateChecksums(Collections2.filter(declaredChangesets, (Predicate)Predicates.not((Predicate)ChangesetRunOnChange.RUN_ON_CHANGE)), persistedChangesets));
        errors.addAll(this.validateOrder(declaredChangesets, persistedChangesets));
        return errors;
    }

    private Collection<String> validateChecksums(Collection<Changeset> declaredChangesets, Collection<Changeset> persistedChangesets) {
        LinkedList errors = Lists.newLinkedList();
        for (Changeset declaredChangeset : declaredChangesets) {
            Optional maybePersistedChangeset = FluentIterable.from(persistedChangesets).firstMatch(ChangesetById.BY_ID(declaredChangeset.getId()));
            if (!maybePersistedChangeset.isPresent()) continue;
            Changeset persistedChangeset = (Changeset)maybePersistedChangeset.get();
            String declaredChecksum = declaredChangeset.getChecksum();
            String persistedChecksum = persistedChangeset.getChecksum();
            if (persistedChecksum.equals(declaredChecksum)) continue;
            errors.add(this.checksumMismatchError(declaredChangeset, persistedChangeset));
        }
        return errors;
    }

    private Collection<String> validateOrder(Collection<Changeset> declaredChangesets, Collection<Changeset> persistedChangesets) {
        LinkedList errors = Lists.newLinkedList();
        int difference = declaredChangesets.size() - persistedChangesets.size();
        if (difference < 0) {
            errors.add(String.format("At least %d declared changeset(s) is/are missing.", Math.abs(difference)));
            return errors;
        }
        for (int i = 0; i < persistedChangesets.size(); ++i) {
            Changeset declared = (Changeset)Iterables.get(declaredChangesets, (int)i);
            Changeset persisted = (Changeset)Iterables.get(persistedChangesets, (int)i);
            String persistedId = persisted.getId();
            String declaredId = declared.getId();
            if (declaredId.equals(persistedId)) continue;
            errors.add(this.idMismatchError(i, persistedId, declaredId));
        }
        return errors;
    }

    private String checksumMismatchError(Changeset declaredChangeset, Changeset persistedChangeset) {
        return String.format("Changeset with ID <%s> has conflicted checksums.%n\t - Declared: <%s>%n\t - Persisted: <%s>.", declaredChangeset.getId(), declaredChangeset.getChecksum(), persistedChangeset.getChecksum());
    }

    private String idMismatchError(int i, String persistedId, String declaredId) {
        return String.format("Declared changeset number %d should have%n\t\t - ID:\t <%s> %n\t\t - Found:\t<%s>.", i + 1, persistedId, declaredId);
    }
}

