/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.validation;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Collection;
import java.util.LinkedList;
import org.liquigraph.core.model.Changeset;
import org.liquigraph.core.model.functions.ChangesetToId;

public class DeclaredChangesetValidator {
    public Collection<String> validate(Collection<Changeset> changesets) {
        LinkedList errors = Lists.newLinkedList();
        errors.addAll(this.validateMandatoryAttributes(changesets));
        errors.addAll(this.validateIdUniqueness(changesets));
        return errors;
    }

    private Collection<String> validateMandatoryAttributes(Collection<Changeset> changesets) {
        LinkedList errors = Lists.newLinkedList();
        int i = 1;
        for (Changeset changeset : changesets) {
            if (Strings.emptyToNull((String)changeset.getId()) == null) {
                errors.add(String.format("Changeset %d - 'id' should not be missing/blank.", i));
            }
            if (Strings.emptyToNull((String)changeset.getAuthor()) == null) {
                errors.add(String.format("Changeset %d - 'author' should not be missing/blank.", i));
            }
            if (Strings.emptyToNull((String)changeset.getQuery()) == null) {
                errors.add(String.format("Changeset %d - 'query' should not be missing/blank.", i));
            }
            ++i;
        }
        return errors;
    }

    private Collection<String> validateIdUniqueness(Collection<Changeset> declaredChangesets) {
        LinkedList errors = Lists.newLinkedList();
        Collection<String> repeatedIds = this.repeatedIds(declaredChangesets);
        if (!repeatedIds.isEmpty()) {
            errors.add(String.format("<%s> is/are declared more than once.", Joiner.on((String)",").join(repeatedIds)));
        }
        return errors;
    }

    private Collection<String> repeatedIds(Collection<Changeset> declaredChangesets) {
        LinkedHashMultiset ids = LinkedHashMultiset.create(this.changesetIds(declaredChangesets));
        return Multisets.filter((Multiset)ids, (Predicate)new Predicate<String>((Multiset)ids){
            final /* synthetic */ Multiset val$ids;
            {
                this.val$ids = multiset;
            }

            public boolean apply(String input) {
                return this.val$ids.count((Object)input) > 1;
            }
        }).elementSet();
    }

    private Collection<String> changesetIds(Collection<Changeset> declaredChangesets) {
        return FluentIterable.from(declaredChangesets).transform((Function)ChangesetToId.INTO_ID).filter(Predicates.notNull()).toList();
    }
}

