/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.model;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.liquigraph.core.model.Checksums;
import org.liquigraph.core.model.Precondition;

public class Changeset {
    private String id;
    private String author;
    private String query;
    private String checksum;
    private Collection<String> executionsContexts = Lists.newArrayList();
    private boolean runOnChange;
    private boolean runAlways;
    private Precondition precondition;

    @XmlAttribute(name="id", required=true)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlAttribute(name="author", required=true)
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @XmlElement(name="query", required=true)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
        this.setChecksum(Checksums.checksum(query));
    }

    @XmlTransient
    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        Preconditions.checkArgument((checksum != null ? 1 : 0) != 0, (Object)"Checksum cannot be null");
        Preconditions.checkArgument((boolean)checksum.equals(Checksums.checksum(this.query)), (Object)this.checksumError(this.id, Checksums.checksum(this.query), checksum));
        this.checksum = checksum;
    }

    @XmlTransient
    public Collection<String> getExecutionsContexts() {
        return this.executionsContexts;
    }

    @XmlAttribute(name="contexts", required=false)
    String getContexts() {
        return this.executionsContexts == null ? "" : Joiner.on((char)',').join(this.executionsContexts);
    }

    public void setContexts(String executionsContexts) {
        this.executionsContexts = Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)Strings.nullToEmpty((String)executionsContexts));
    }

    @XmlAttribute(name="run-on-change", required=false)
    public boolean isRunOnChange() {
        return this.runOnChange;
    }

    public void setRunOnChange(boolean runOnChange) {
        this.runOnChange = runOnChange;
    }

    @XmlAttribute(name="run-always", required=false)
    public boolean isRunAlways() {
        return this.runAlways;
    }

    public void setRunAlways(boolean runAlways) {
        this.runAlways = runAlways;
    }

    @XmlElement(name="precondition", required=false)
    public Precondition getPrecondition() {
        return this.precondition;
    }

    public void setPrecondition(Precondition precondition) {
        this.precondition = precondition;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.checksum);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Changeset other = (Changeset)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.checksum, other.checksum);
    }

    public String toString() {
        return "Changeset{id='" + this.id + '\'' + ", author='" + this.author + '\'' + ", query='" + this.query + '\'' + ", checksum='" + this.checksum + '\'' + ", executionsContexts=" + this.executionsContexts + ", runOnChange=" + this.runOnChange + ", runAlways=" + this.runAlways + ", precondition=" + this.precondition + '}';
    }

    private String checksumError(String id, String expected, String actual) {
        return String.format("Changeset <%s>. Checksum mismatch!%n\t Expected: %s%n\t Actual: %s", id, expected, actual);
    }
}

