/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.model;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.liquigraph.core.model.CompoundQueries;
import org.liquigraph.core.model.CompoundQuery;
import org.liquigraph.core.model.OrQuery;
import org.liquigraph.core.model.PreconditionQuery;
import org.liquigraph.core.model.SimpleQuery;

@XmlSeeAlso(value={PreconditionQuery.class})
@XmlRootElement(name="and")
public class AndQuery
implements CompoundQuery {
    private List<PreconditionQuery> preconditionQueries = Lists.newArrayList();

    @XmlElementRefs(value={@XmlElementRef(name="and", type=AndQuery.class), @XmlElementRef(name="or", type=OrQuery.class), @XmlElementRef(name="query", type=SimpleQuery.class)})
    public List<PreconditionQuery> getPreconditionQueries() {
        return this.preconditionQueries;
    }

    public void setPreconditionQueries(List<PreconditionQuery> preconditionQueries) {
        this.preconditionQueries = preconditionQueries;
    }

    @Override
    public PreconditionQuery getFirstQuery() {
        CompoundQueries.checkQueryListState(this.preconditionQueries);
        return this.preconditionQueries.get(0);
    }

    @Override
    public PreconditionQuery getSecondQuery() {
        CompoundQueries.checkQueryListState(this.preconditionQueries);
        return this.preconditionQueries.get(1);
    }

    @Override
    public boolean compose(boolean firstResult, boolean secondResult) {
        return firstResult && secondResult;
    }

    @Override
    public String compose(String firstQuery, String secondQuery) {
        return String.format("((%s) AND (%s))", firstQuery, secondQuery);
    }

    public int hashCode() {
        return Objects.hash(this.preconditionQueries);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AndQuery other = (AndQuery)obj;
        return Objects.equals(this.preconditionQueries, other.preconditionQueries);
    }

    public String toString() {
        return String.format("<%s> AND <%s>", this.getFirstQuery(), this.getSecondQuery());
    }
}

