/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration.validators;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;

public class MandatoryOptionValidator {
    public Collection<String> validate(ClassLoader classLoader, String masterChangelog, String uri) {
        LinkedList<String> errors = new LinkedList<String>();
        errors.addAll(MandatoryOptionValidator.validateMasterChangelog(masterChangelog, classLoader));
        errors.addAll(MandatoryOptionValidator.validateGraphInstance(uri));
        return errors;
    }

    private static Collection<String> validateMasterChangelog(String masterChangelog, ClassLoader classLoader) {
        LinkedList<String> errors = new LinkedList<String>();
        if (masterChangelog == null) {
            errors.add("'masterChangelog' should not be null");
        } else {
            try (InputStream stream = classLoader.getResourceAsStream(masterChangelog);){
                if (stream == null) {
                    errors.add(String.format("'masterChangelog' points to a non-existing location: %s", masterChangelog));
                }
            }
            catch (IOException e) {
                errors.add(String.format("'masterChangelog' read error. Cause: %s", e.getMessage()));
            }
        }
        return errors;
    }

    private static Collection<String> validateGraphInstance(String uri) {
        LinkedList<String> errors = new LinkedList<String>();
        if (uri == null) {
            errors.add("'uri' should not be null");
        } else if (!uri.startsWith("jdbc:neo4j:")) {
            errors.add(String.format("Invalid JDBC URI. Supported configurations:%n\t - jdbc:neo4j://<host>:<port>/%n\t - jdbc:neo4j:file:/path/to/db%n\t - jdbc:neo4j:mem or jdbc:neo4j:mem:name.%nGiven: %s", uri));
        }
        return errors;
    }
}

