/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration;

import com.google.common.base.Optional;
import java.sql.Connection;
import org.liquigraph.core.configuration.DryRunMode;
import org.liquigraph.core.configuration.ExecutionContexts;
import org.liquigraph.core.configuration.ExecutionMode;
import org.liquigraph.core.configuration.RunMode;
import org.liquigraph.core.writer.ChangelogFileWriter;
import org.liquigraph.core.writer.ChangelogGraphWriter;
import org.liquigraph.core.writer.ChangelogWriter;
import org.liquigraph.core.writer.PreconditionExecutor;
import org.liquigraph.core.writer.PreconditionPrinter;

public final class Configuration {
    private final ClassLoader classLoader;
    private final String masterChangelog;
    private final String uri;
    private final Optional<String> username;
    private final Optional<String> password;
    private final ExecutionContexts executionContexts;
    private final ExecutionMode executionMode;

    Configuration(ClassLoader classLoader, String masterChangelog, String uri, Optional<String> username, Optional<String> password, ExecutionContexts executionContexts, ExecutionMode executionMode) {
        this.classLoader = classLoader;
        this.masterChangelog = masterChangelog;
        this.uri = uri;
        this.username = username;
        this.password = password;
        this.executionContexts = executionContexts;
        this.executionMode = executionMode;
    }

    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public String masterChangelog() {
        return this.masterChangelog;
    }

    public String uri() {
        return this.uri;
    }

    public Optional<String> username() {
        return this.username;
    }

    public Optional<String> password() {
        return this.password;
    }

    public ExecutionContexts executionContexts() {
        return this.executionContexts;
    }

    public ExecutionMode executionMode() {
        return this.executionMode;
    }

    public ChangelogWriter resolveWriter(Connection connection, PreconditionExecutor preconditionExecutor, PreconditionPrinter preconditionPrinter) {
        ExecutionMode executionMode = this.executionMode();
        if (executionMode == RunMode.RUN_MODE) {
            return new ChangelogGraphWriter(connection, preconditionExecutor);
        }
        if (executionMode instanceof DryRunMode) {
            DryRunMode dryRunMode = (DryRunMode)executionMode;
            return new ChangelogFileWriter(preconditionPrinter, dryRunMode.getOutputFile());
        }
        throw new IllegalStateException("Unsupported <executionMode>: " + executionMode);
    }
}

