/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.api;

import com.google.common.base.Joiner;
import java.sql.Connection;
import java.util.Collection;
import org.liquigraph.core.api.ChangelogDiffMaker;
import org.liquigraph.core.configuration.Configuration;
import org.liquigraph.core.model.Changeset;
import org.liquigraph.core.parser.ChangelogParser;
import org.liquigraph.core.validation.DeclaredChangesetValidator;
import org.liquigraph.core.validation.PersistedChangesetValidator;
import org.liquigraph.core.writer.ChangelogReader;
import org.liquigraph.core.writer.ChangelogWriter;
import org.liquigraph.core.writer.GraphJdbcConnector;
import org.liquigraph.core.writer.PreconditionExecutor;
import org.liquigraph.core.writer.PreconditionPrinter;

class MigrationRunner {
    private final GraphJdbcConnector connector;
    private final ChangelogParser changelogParser;
    private final ChangelogReader changelogReader;
    private final ChangelogDiffMaker changelogDiffMaker;
    private final PreconditionExecutor preconditionExecutor;
    private final PreconditionPrinter preconditionPrinter;
    private final DeclaredChangesetValidator declaredChangesetValidator;
    private final PersistedChangesetValidator persistedChangesetValidator;

    public MigrationRunner(GraphJdbcConnector connector, ChangelogParser changelogParser, ChangelogReader changelogReader, ChangelogDiffMaker changelogDiffMaker, PreconditionExecutor preconditionExecutor, PreconditionPrinter preconditionPrinter, DeclaredChangesetValidator declaredChangesetValidator, PersistedChangesetValidator persistedChangesetValidator) {
        this.connector = connector;
        this.changelogParser = changelogParser;
        this.changelogReader = changelogReader;
        this.changelogDiffMaker = changelogDiffMaker;
        this.preconditionExecutor = preconditionExecutor;
        this.preconditionPrinter = preconditionPrinter;
        this.declaredChangesetValidator = declaredChangesetValidator;
        this.persistedChangesetValidator = persistedChangesetValidator;
    }

    public void runMigrations(Configuration configuration) {
        Collection<Changeset> declaredChangesets = this.parseChangesets(configuration.classLoader(), configuration.masterChangelog());
        Connection connection = this.connector.connect(configuration);
        Collection<Changeset> persistedChangesets = this.readPersistedChangesets(declaredChangesets, connection);
        Collection<Changeset> changelogsToInsert = this.changelogDiffMaker.computeChangesetsToInsert(configuration.executionContexts(), declaredChangesets, persistedChangesets);
        this.writeDiff(configuration, connection, changelogsToInsert);
    }

    private Collection<Changeset> parseChangesets(ClassLoader classLoader, String masterChangelog) {
        Collection<Changeset> declaredChangesets = this.changelogParser.parse(classLoader, masterChangelog);
        Collection<String> errors = this.declaredChangesetValidator.validate(declaredChangesets);
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(this.formatErrorMessage(errors));
        }
        return declaredChangesets;
    }

    private Collection<Changeset> readPersistedChangesets(Collection<Changeset> declaredChangesets, Connection graphDatabase) {
        Collection<Changeset> persistedChangesets = this.changelogReader.read(graphDatabase);
        Collection<String> errors = this.persistedChangesetValidator.validate(declaredChangesets, persistedChangesets);
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(this.formatErrorMessage(errors));
        }
        return persistedChangesets;
    }

    private void writeDiff(Configuration configuration, Connection connection, Collection<Changeset> changelogsToInsert) {
        ChangelogWriter changelogWriter = configuration.resolveWriter(connection, this.preconditionExecutor, this.preconditionPrinter);
        changelogWriter.write(changelogsToInsert);
    }

    private String formatErrorMessage(Collection<String> errors) {
        String separator = "\n\t";
        return separator + Joiner.on((String)separator).join(errors);
    }
}

