/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.writer;

import com.google.common.base.Throwables;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.liquigraph.core.exception.PreconditionNotMetException;
import org.liquigraph.core.model.Changeset;
import org.liquigraph.core.model.Precondition;
import org.liquigraph.core.writer.ChangelogWriter;
import org.liquigraph.core.writer.PreconditionExecutor;
import org.liquigraph.core.writer.PreconditionResult;

public class ChangelogGraphWriter
implements ChangelogWriter {
    private static final String LATEST_INDEX = "MERGE (changelog:__LiquigraphChangelog) WITH changelog OPTIONAL MATCH (changelog)<-[exec:EXECUTED_WITHIN_CHANGELOG]-(:__LiquigraphChangeset)RETURN COALESCE(MAX(exec.order), 0) AS lastIndex";
    private static final String CHANGESET_UPSERT = "MATCH (changelog:__LiquigraphChangelog) MERGE (changelog)<-[:EXECUTED_WITHIN_CHANGELOG {order: {1}}]-(changeset:__LiquigraphChangeset {id: {2}}) ON MATCH SET  changeset.checksum = {3},               changeset.query = {4} ON CREATE SET changeset.author = {5},               changeset.query = {4},               changeset.checksum = {3}";
    private final Connection connection;
    private final PreconditionExecutor preconditionExecutor;

    public ChangelogGraphWriter(Connection connection, PreconditionExecutor preconditionExecutor) {
        this.connection = connection;
        this.preconditionExecutor = preconditionExecutor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(Collection<Changeset> changelogsToInsert) {
        long index = this.latestPersistedIndex(this.connection) + 1L;
        Iterator<Changeset> iterator = changelogsToInsert.iterator();
        block19: while (iterator.hasNext()) {
            Changeset changeset = iterator.next();
            Precondition precondition = changeset.getPrecondition();
            try {
                Statement statement = this.connection.createStatement();
                Throwable throwable = null;
                try {
                    PreconditionResult preconditionResult = this.executePrecondition(precondition);
                    if (preconditionResult == null || preconditionResult.executedSuccessfully()) {
                        statement.execute(changeset.getQuery());
                        this.upsertChangeset(this.connection, index, changeset);
                    } else {
                        switch (preconditionResult.errorPolicy()) {
                            case CONTINUE: {
                                continue block19;
                            }
                            case MARK_AS_EXECUTED: {
                                this.upsertChangeset(this.connection, index, changeset);
                                break;
                            }
                            case FAIL: {
                                throw new PreconditionNotMetException(String.format("Changeset <%s>: precondition query %s failed with policy <%s>. Aborting.", new Object[]{changeset.getId(), precondition.getQuery(), precondition.getPolicy()}));
                            }
                        }
                    }
                    this.connection.commit();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    statement.close();
                    continue;
                }
            }
            catch (SQLException e) {
                throw Throwables.propagate((Throwable)e);
            }
            ++index;
        }
        return;
    }

    private PreconditionResult executePrecondition(Precondition precondition) {
        PreconditionResult result;
        try (Statement ignored = this.connection.createStatement();){
            result = (PreconditionResult)this.preconditionExecutor.executePrecondition(this.connection, precondition).orNull();
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return result;
    }

    private void upsertChangeset(Connection connection, long index, Changeset changeset) {
        Map<Integer, Object> parameters = this.parameters(changeset, index);
        try (PreparedStatement statement = connection.prepareStatement(CHANGESET_UPSERT);){
            for (Integer key : parameters.keySet()) {
                statement.setObject(key, parameters.get(key));
            }
            statement.execute();
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long latestPersistedIndex(Connection connection) {
        try (Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(LATEST_INDEX);
            resultSet.next();
            long l = resultSet.getLong("lastIndex");
            return l;
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Map<Integer, Object> parameters(Changeset changeset, long index) {
        String query = changeset.getQuery();
        String checksum = changeset.getChecksum();
        HashMap<Integer, Object> parameters = new HashMap<Integer, Object>();
        parameters.put(1, index);
        parameters.put(2, changeset.getId());
        parameters.put(3, checksum);
        parameters.put(4, query);
        parameters.put(5, changeset.getAuthor());
        return parameters;
    }
}

