/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.writer;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedList;
import org.liquigraph.core.model.Changeset;
import org.liquigraph.core.writer.ChangelogWriter;
import org.liquigraph.core.writer.PreconditionPrinter;

public class ChangelogFileWriter
implements ChangelogWriter {
    private final PreconditionPrinter preconditionPrinter;
    private final File outputFile;

    public ChangelogFileWriter(PreconditionPrinter preconditionPrinter, File outputFile) {
        this.preconditionPrinter = preconditionPrinter;
        this.outputFile = outputFile;
    }

    @Override
    public void write(Collection<Changeset> changelogsToInsert) {
        try {
            this.reinitializeFile(this.outputFile.toPath());
            for (Changeset changeset : changelogsToInsert) {
                this.writeChangeset(changeset, this.outputFile.toPath());
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void reinitializeFile(Path path) throws IOException {
        Files.deleteIfExists(path);
        Files.createFile(path, new FileAttribute[0]);
    }

    private void writeChangeset(Changeset changeset, Path path) throws IOException {
        Files.write(path, this.preconditionPrinter.print(changeset.getPrecondition()), Charsets.UTF_8, StandardOpenOption.APPEND);
        Files.write(path, this.changesetToString(changeset), Charsets.UTF_8, StandardOpenOption.APPEND);
    }

    private Collection<String> changesetToString(Changeset changeset) {
        LinkedList lines = Lists.newLinkedList();
        lines.add(String.format("//Liquigraph changeset[author: %s, id: %s]", changeset.getAuthor(), changeset.getId()));
        lines.add(String.format("//Liquigraph changeset[executionContexts: %s]", this.flatten(changeset.getExecutionsContexts())));
        lines.add(changeset.getQuery());
        return lines;
    }

    private String flatten(Collection<String> executionsContexts) {
        if (executionsContexts.isEmpty()) {
            return "none declared";
        }
        return Joiner.on((String)",").join(executionsContexts);
    }
}

