/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.liquigraph.core.model.Changelog;
import org.liquigraph.core.model.Changeset;

public final class ChangelogParser {
    public Collection<Changeset> parse(ClassLoader classLoader, String masterChangelog) {
        return this.parseChangelog(classLoader, masterChangelog).getChangesets();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Changelog parseChangelog(ClassLoader classLoader, String masterChangelog) {
        try (InputStream changelogStream = classLoader.getResourceAsStream(masterChangelog);){
            Changelog changelog = (Changelog)JAXBContext.newInstance((Class[])new Class[]{Changelog.class}).createUnmarshaller().unmarshal(changelogStream);
            return changelog;
        }
        catch (IOException | JAXBException e) {
            throw new IllegalArgumentException(String.format("Unable to parse changelog <%s>.", masterChangelog), e);
        }
    }
}

