/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import org.liquigraph.core.configuration.Configuration;
import org.liquigraph.core.configuration.DryRunMode;
import org.liquigraph.core.configuration.ExecutionContexts;
import org.liquigraph.core.configuration.ExecutionMode;
import org.liquigraph.core.configuration.RunMode;
import org.liquigraph.core.configuration.validators.ExecutionModeValidator;
import org.liquigraph.core.configuration.validators.MandatoryOptionValidator;

public final class ConfigurationBuilder {
    private String masterChangelog;
    private String uri;
    private Optional<String> username = Optional.absent();
    private Optional<String> password = Optional.absent();
    private ExecutionContexts executionContexts = ExecutionContexts.DEFAULT_CONTEXT;
    private ExecutionMode executionMode;
    private MandatoryOptionValidator mandatoryOptionValidator = new MandatoryOptionValidator();
    private ExecutionModeValidator executionModeValidator = new ExecutionModeValidator();
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public ConfigurationBuilder withMasterChangelogLocation(String masterChangelog) {
        this.masterChangelog = masterChangelog;
        return this;
    }

    public ConfigurationBuilder withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public ConfigurationBuilder withUsername(String username) {
        this.username = Optional.fromNullable((Object)username);
        return this;
    }

    public ConfigurationBuilder withPassword(String password) {
        this.password = Optional.fromNullable((Object)password);
        return this;
    }

    public ConfigurationBuilder withExecutionContexts(String ... executionContexts) {
        return this.withExecutionContexts(Lists.newArrayList((Object[])executionContexts));
    }

    public ConfigurationBuilder withExecutionContexts(Collection<String> executionContexts) {
        if (!executionContexts.isEmpty()) {
            this.executionContexts = new ExecutionContexts(executionContexts);
        }
        return this;
    }

    public ConfigurationBuilder withRunMode() {
        this.executionMode = RunMode.RUN_MODE;
        return this;
    }

    public ConfigurationBuilder withDryRunMode(Path outputDirectory) {
        this.executionMode = new DryRunMode(outputDirectory);
        return this;
    }

    public ConfigurationBuilder withClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
        return this;
    }

    public Configuration build() {
        LinkedList errors = Lists.newLinkedList();
        errors.addAll(this.mandatoryOptionValidator.validate(this.classLoader, this.masterChangelog, this.uri));
        errors.addAll(this.executionModeValidator.validate(this.executionMode));
        if (!errors.isEmpty()) {
            throw new RuntimeException(this.formatErrors(errors));
        }
        return new Configuration(this.classLoader, this.masterChangelog, this.uri, this.username, this.password, this.executionContexts, this.executionMode);
    }

    private String formatErrors(Collection<String> errors) {
        String separator = "\n\t - ";
        return String.format("%s%s", separator, Joiner.on((String)separator).join(errors));
    }
}

