/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.api;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import java.util.Collection;
import org.liquigraph.core.configuration.ExecutionContexts;
import org.liquigraph.core.model.Changeset;
import org.liquigraph.core.model.predicates.ChangesetChecksumHasChanged;
import org.liquigraph.core.model.predicates.ChangesetMatchAnyExecutionContexts;
import org.liquigraph.core.model.predicates.ChangesetRunAlways;
import org.liquigraph.core.model.predicates.ChangesetRunOnChange;

class ChangelogDiffMaker {
    ChangelogDiffMaker() {
    }

    public Collection<Changeset> computeChangesetsToInsert(ExecutionContexts executionContexts, Collection<Changeset> declaredChangesets, Collection<Changeset> persistedChangesets) {
        return this.diff(executionContexts, declaredChangesets, persistedChangesets);
    }

    private Collection<Changeset> diff(ExecutionContexts executionContexts, Collection<Changeset> declaredChangesets, Collection<Changeset> persistedChangesets) {
        return FluentIterable.from(declaredChangesets).filter((Predicate)ChangesetMatchAnyExecutionContexts.BY_ANY_EXECUTION_CONTEXT(executionContexts)).filter(Predicates.or((Predicate[])new Predicate[]{Predicates.not((Predicate)Predicates.in(persistedChangesets)), Predicates.and((Predicate)ChangesetRunOnChange.RUN_ON_CHANGE, ChangesetChecksumHasChanged.CHECKSUM_HAS_CHANGED(persistedChangesets)), ChangesetRunAlways.RUN_ALWAYS})).toList();
    }
}

