/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.dialogs;

import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.util.Objects;
import org.linkki.core.binding.BindingContext;
import org.linkki.core.binding.dispatcher.PropertyBehaviorProvider;
import org.linkki.core.binding.validation.ValidationService;
import org.linkki.core.ui.section.DefaultPmoBasedSectionFactory;
import org.linkki.core.ui.section.PmoBasedSectionFactory;
import org.linkki.core.ui.table.ContainerPmo;
import org.linkki.framework.ui.dialogs.DialogBindingManager;
import org.linkki.framework.ui.dialogs.OkCancelDialog;
import org.linkki.util.handler.Handler;

public class PmoBasedDialogFactory {
    private final PmoBasedSectionFactory pmoBasedSectionFactory;
    private final ValidationService validationService;
    private final PropertyBehaviorProvider propertyBehaviorProvider;

    public PmoBasedDialogFactory() {
        this(ValidationService.NOP_VALIDATION_SERVICE);
    }

    public PmoBasedDialogFactory(ValidationService validationService) {
        this(validationService, PropertyBehaviorProvider.NO_BEHAVIOR_PROVIDER);
    }

    public PmoBasedDialogFactory(ValidationService validationService, PropertyBehaviorProvider propertyBehaviorProvider) {
        this.validationService = Objects.requireNonNull(validationService, "validationService must not be null");
        this.propertyBehaviorProvider = Objects.requireNonNull(propertyBehaviorProvider, "propertyBehaviorProvider must not be null");
        this.pmoBasedSectionFactory = new DefaultPmoBasedSectionFactory();
    }

    @Deprecated
    public OkCancelDialog newOkCancelDialog(String title, Object pmo, Handler okHandler) {
        return this.newOkCancelDialog(title, okHandler, pmo);
    }

    public OkCancelDialog newOkCancelDialog(String title, Handler okHandler, Object ... pmos) {
        OkCancelDialog dialog = new OkCancelDialog(title, okHandler, OkCancelDialog.ButtonOption.OK_CANCEL);
        DialogBindingManager bindingManager = new DialogBindingManager(dialog, this.validationService, this.propertyBehaviorProvider);
        BindingContext bindingContext = bindingManager.startNewContext(((Object)((Object)dialog)).getClass());
        for (Object pmo : pmos) {
            Object content = pmo instanceof ContainerPmo ? this.pmoBasedSectionFactory.createTableSection((ContainerPmo)pmo, bindingContext) : this.pmoBasedSectionFactory.createSection(pmo, bindingContext);
            float expRatio = 0.0f;
            if (pmo == pmos[pmos.length - 1]) {
                expRatio = 1.0f;
            }
            dialog.addContent((Component)content, expRatio);
        }
        bindingContext.updateUI();
        return dialog;
    }

    public OkCancelDialog openOkCancelDialog(String title, Object pmo, Handler okHandler) {
        return PmoBasedDialogFactory.open(this.newOkCancelDialog(title, okHandler, pmo));
    }

    public static OkCancelDialog open(OkCancelDialog dialog) {
        UI.getCurrent().addWindow((Window)dialog);
        return dialog;
    }
}

