/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.dialogs;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.linkki.core.binding.validation.ValidationDisplayState;
import org.linkki.core.binding.validation.ValidationService;
import org.linkki.core.message.Message;
import org.linkki.core.message.MessageList;
import org.linkki.framework.ui.component.MessageRow;
import org.linkki.framework.ui.nls.NlsText;
import org.linkki.util.handler.Handler;

public class OkCancelDialog
extends Window {
    private static final long serialVersionUID = 1L;
    private boolean okPressed = false;
    private boolean cancelPressed = false;
    private final VerticalLayout layout;
    private final VerticalLayout contentArea;
    private final VerticalLayout mainArea;
    private final Button okButton;
    private final Handler okHandler;
    private MessageList messages = new MessageList(new Message[0]);
    private ValidationService validationService = ValidationService.NOP_VALIDATION_SERVICE;
    private ValidationDisplayState validationDisplayState = ValidationDisplayState.HIDE_MANDATORY_FIELD_VALIDATIONS;
    private Optional<MessageRow> messageRow = Optional.empty();

    public OkCancelDialog(String caption) {
        this(caption, Handler.NOP_HANDLER, ButtonOption.OK_CANCEL);
    }

    public OkCancelDialog(String caption, Handler okHandler) {
        this(caption, okHandler, ButtonOption.OK_CANCEL);
    }

    public OkCancelDialog(String caption, Handler okHandler, ButtonOption buttonOption) {
        this(caption, null, okHandler, buttonOption);
    }

    public OkCancelDialog(String caption, @Nullable Component content, Handler okHandler, ButtonOption buttonOption) {
        super(caption);
        this.okHandler = Objects.requireNonNull(okHandler, "okHandler must not be null");
        this.layout = new VerticalLayout();
        this.contentArea = new VerticalLayout();
        this.mainArea = new VerticalLayout();
        this.okButton = new Button(NlsText.getString("OkCancelDialog.OkButtonCaption"));
        this.okButton.setClickShortcut(13, new int[0]);
        this.okButton.setStyleName("primary");
        this.initDialogWindow();
        this.initLayout();
        this.initMainArea(content);
        this.initButtons(buttonOption);
        this.initCloseListener();
        super.setContent((Component)this.layout);
        this.center();
    }

    public void setContent(@Nullable Component content) {
        if (this.mainArea == null) {
            super.setContent(content);
        } else {
            this.mainArea.removeAllComponents();
            this.mainArea.addComponent(content);
        }
    }

    private void initDialogWindow() {
        this.setStyleName("linkki-dialog-caption");
        this.setModal(true);
        this.setResizable(false);
    }

    private void initLayout() {
        this.layout.setWidth("100%");
        this.layout.setMargin(true);
        this.layout.addComponent((Component)this.contentArea);
        this.layout.setExpandRatio((Component)this.contentArea, 1.0f);
    }

    private void initMainArea(@Nullable Component c) {
        this.mainArea.addStyleName("linkki-dialog-content");
        this.contentArea.addStyleName("content-area");
        this.contentArea.addComponent((Component)this.mainArea);
        this.contentArea.setExpandRatio((Component)this.mainArea, 1.0f);
        if (c != null) {
            this.mainArea.addComponent(c);
        }
    }

    private void initButtons(ButtonOption buttonOption) {
        HorizontalLayout buttons = this.createButtons(buttonOption);
        this.layout.addComponent((Component)buttons);
        this.layout.setExpandRatio((Component)buttons, 0.0f);
        this.layout.setComponentAlignment((Component)buttons, Alignment.MIDDLE_CENTER);
    }

    private void initCloseListener() {
        this.addCloseListener((Window.CloseListener & Serializable)e -> {
            if (!this.isOkPressed() && !this.isCancelPressed()) {
                this.cancel();
            }
        });
    }

    private HorizontalLayout createButtons(ButtonOption buttonOption) {
        HorizontalLayout buttons = new HorizontalLayout();
        buttons.addStyleName("linkki-dialog-button-bar");
        buttons.setSpacing(true);
        buttons.addComponent((Component)this.okButton);
        buttons.setComponentAlignment((Component)this.okButton, Alignment.BOTTOM_CENTER);
        this.okButton.addClickListener((Button.ClickListener & Serializable)e -> {
            this.setOkPressed();
            if (!this.validate().containsErrorMsg()) {
                this.ok();
                this.close();
            }
        });
        if (buttonOption == ButtonOption.OK_CANCEL) {
            Button cancel = new Button(NlsText.getString("OkCancelDialog.CancelButtonCaption"));
            buttons.addComponent((Component)cancel);
            buttons.setComponentAlignment((Component)cancel, Alignment.MIDDLE_CENTER);
            cancel.addClickListener((Button.ClickListener & Serializable)e -> {
                this.setCancelPressed(true);
                this.cancel();
                this.close();
            });
        }
        return buttons;
    }

    public void setSize(String width, String height) {
        this.setHeight(height);
        this.setWidth(width);
        this.layout.setSizeFull();
        this.contentArea.setSizeFull();
        this.mainArea.setSizeFull();
    }

    public MessageList validate() {
        this.messages = this.validationDisplayState.filter(this.validationService.getValidationMessages());
        this.messageRow.ifPresent(arg_0 -> ((VerticalLayout)this.contentArea).removeComponent(arg_0));
        this.getMessageToDisplay().ifPresent(m -> {
            MessageRow newRow = new MessageRow((Message)m);
            newRow.setWidth("100%");
            this.messageRow = Optional.of(newRow);
            this.contentArea.addComponent((Component)newRow);
            this.contentArea.setExpandRatio((Component)newRow, 0.0f);
            this.contentArea.setComponentAlignment((Component)newRow, Alignment.MIDDLE_LEFT);
        });
        this.update();
        return this.messages;
    }

    public MessageList getMessages() {
        return this.messages;
    }

    public ValidationService getValidationService() {
        return this.validationService;
    }

    public void setValidationService(ValidationService validationService) {
        this.validationService = Objects.requireNonNull(validationService, "validationService must not be null");
    }

    private Optional<Message> getMessageToDisplay() {
        return this.messages.getErrorLevel().flatMap(arg_0 -> ((MessageList)this.messages).getFirstMessage(arg_0));
    }

    private void update() {
        this.okButton.setEnabled(this.isOkEnabled());
    }

    public void addContent(Component c) {
        this.mainArea.addComponent(c);
    }

    public void addContent(Component c, float expandRatio) {
        this.mainArea.addComponent(c);
        this.mainArea.setExpandRatio(c, expandRatio);
    }

    public boolean isOkEnabled() {
        return !this.messages.containsErrorMsg();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public ValidationDisplayState getValidationDisplayState() {
        return this.validationDisplayState;
    }

    private void setOkPressed() {
        this.okPressed = true;
        this.validationDisplayState = ValidationDisplayState.SHOW_ALL;
    }

    public boolean isCancelPressed() {
        return this.cancelPressed;
    }

    private void setCancelPressed(boolean cancelPressed) {
        this.cancelPressed = cancelPressed;
    }

    protected void ok() {
        this.okHandler.apply();
    }

    protected void cancel() {
    }

    public static enum ButtonOption {
        OK_ONLY,
        OK_CANCEL;

    }
}

