/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.component.sidebar;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SidebarSheet {
    private final Button button;
    private final Component content;
    private final String tooltip;

    public SidebarSheet(Resource icon, Component content, String tooltip) {
        this.button = new Button("", Objects.requireNonNull(icon, "icon must not be null"));
        this.content = Objects.requireNonNull(content, "content must not be null");
        this.tooltip = Objects.requireNonNull(tooltip, "tooltip must not be null");
        if (StringUtils.isNotEmpty((CharSequence)tooltip)) {
            this.button.setDescription(tooltip);
        }
    }

    public Button getButton() {
        return this.button;
    }

    public Component getContent() {
        return this.content;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    void select() {
        this.getContent().setVisible(true);
        this.getButton().addStyleName("selected");
    }

    void unselect() {
        this.getButton().removeStyleName("selected");
        this.getContent().setVisible(false);
    }
}

