/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.component.sidebar;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.linkki.framework.ui.component.sidebar.SidebarSheet;

public class SidebarLayout
extends CssLayout {
    private static final long serialVersionUID = -8283594476427895723L;
    private final CssLayout sidebar;
    private final CssLayout contentArea;
    private Optional<SidebarSheet> selected = Optional.empty();

    public SidebarLayout() {
        this.sidebar = new CssLayout();
        this.contentArea = new CssLayout();
        this.setSizeFull();
        this.contentArea.setSizeFull();
        this.setStyleName("linkki-sidebar-layout");
        this.sidebar.setStyleName("linkki-sidebar");
        this.contentArea.setStyleName("linkki-sidebar-content");
        this.addComponent((Component)this.sidebar);
        this.addComponent((Component)this.contentArea);
    }

    public void addSheets(Stream<SidebarSheet> sheets) {
        sheets.forEach(this::addSheet);
    }

    public void addSheets(Iterable<SidebarSheet> sheets) {
        sheets.forEach(this::addSheet);
    }

    public void addSheets(SidebarSheet ... sheets) {
        this.addSheets(Arrays.stream(sheets));
    }

    public void addSheet(SidebarSheet sheet) {
        sheet.unselect();
        sheet.getButton().addClickListener((Button.ClickListener & Serializable)e -> this.select(sheet));
        this.sidebar.addComponent((Component)sheet.getButton());
        this.contentArea.addComponent(sheet.getContent());
        if (!this.selected.isPresent()) {
            this.select(sheet);
        }
    }

    public void select(SidebarSheet sheet) {
        this.selected.ifPresent(SidebarSheet::unselect);
        this.selected = Optional.of(sheet);
        sheet.select();
    }

    public SidebarSheet getSelected() {
        return this.selected.get();
    }
}

