/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.component;

import com.vaadin.server.FontAwesome;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.message.Message;
import org.linkki.core.message.ObjectProperty;

public class MessagePmo {
    private final Message message;

    public MessagePmo(Message message) {
        this.message = Objects.requireNonNull(message, "message must not be null");
    }

    public String getStyle() {
        return "linkki-message-" + this.message.getErrorLevel().name().toLowerCase();
    }

    public FontAwesome getIcon() {
        switch (this.message.getErrorLevel()) {
            case ERROR: {
                return FontAwesome.EXCLAMATION_CIRCLE;
            }
            case WARNING: {
                return FontAwesome.EXCLAMATION_TRIANGLE;
            }
        }
        return FontAwesome.INFO_CIRCLE;
    }

    public String getText() {
        return this.message.getText();
    }

    public String getToolTip() {
        String text = this.message.getInvalidObjectProperties().stream().map(this::getPropertyDesc).collect(Collectors.joining(", "));
        return text;
    }

    private String getPropertyDesc(ObjectProperty op) {
        String simpleName = op.getObject().getClass().getSimpleName();
        if (StringUtils.isEmpty((CharSequence)op.getProperty())) {
            return simpleName;
        }
        return simpleName + ": " + op.getProperty();
    }
}

