/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.application;

import com.vaadin.cdi.UIScoped;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.FontIcon;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.MenuBar;
import java.io.Serializable;
import javax.inject.Inject;
import org.linkki.core.ui.util.ComponentFactory;
import org.linkki.framework.ui.application.menu.ApplicationMenu;
import org.linkki.framework.ui.nls.NlsText;

@UIScoped
public class ApplicationHeader
extends HorizontalLayout {
    private static final long serialVersionUID = 1L;
    @Inject
    private ApplicationMenu applicationMenu;

    protected void init() {
        this.addStyleName("linkki-application-header");
        this.setMargin(new MarginInfo(true, false, true, false));
        this.addComponent((Component)this.applicationMenu);
        this.applicationMenu.init();
        HorizontalLayout menuWrapper = new HorizontalLayout();
        menuWrapper.addStyleName("linkki-application-menu");
        this.addComponent((Component)menuWrapper);
        this.createSections(menuWrapper);
        this.setExpandRatio((Component)menuWrapper, 1.0f);
    }

    protected void createSections(HorizontalLayout menuWrapper) {
        this.createHelpSection(menuWrapper);
        ComponentFactory.addHorizontalFixedSizeSpacer((AbstractOrderedLayout)menuWrapper, (int)20);
        this.createUserSection(menuWrapper);
    }

    protected void createHelpSection(HorizontalLayout menuWrapper) {
        MenuBar menuBar = new MenuBar();
        menuWrapper.addComponent((Component)menuBar);
        menuBar.setSizeUndefined();
        menuBar.addStyleName("borderless");
        MenuBar.MenuItem item = menuBar.addItem("", (Resource)FontAwesome.QUESTION_CIRCLE, null);
        item.setStyleName("linkki-application-header");
        item.addItem(NlsText.getString("ApplicationHeader.Help"), null);
        item.addItem(NlsText.getString("ApplicationHeader.Shortcuts"), null);
    }

    protected void createUserSection(HorizontalLayout menuWrapper) {
        ComponentFactory.labelIcon((AbstractOrderedLayout)menuWrapper, (FontIcon)FontAwesome.USER);
        String userName = this.getUserName();
        Label l = ComponentFactory.sizedLabel((AbstractOrderedLayout)menuWrapper, (String)userName);
        menuWrapper.setComponentAlignment((Component)l, Alignment.MIDDLE_CENTER);
        MenuBar menuBar = new MenuBar();
        menuWrapper.addComponent((Component)menuBar);
        menuBar.setSizeUndefined();
        menuBar.addStyleName("borderless");
        MenuBar.MenuItem item = menuBar.addItem("", null);
        item.setStyleName("linkki-application-header");
        item.addItem(NlsText.getString("ApplicationHeader.Preferences"), null);
        item.addSeparator();
        item.addItem(NlsText.getString("ApplicationHeader.Logout"), this.newLogoutCommand());
    }

    protected String getUserName() {
        return "anonymous";
    }

    protected MenuBar.Command newLogoutCommand() {
        return (MenuBar.Command & Serializable)selectedItem -> this.getUI().getPage().setLocation("./logout");
    }
}

