/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.application;

import com.vaadin.cdi.CDIViewProvider;
import com.vaadin.cdi.UIScoped;
import com.vaadin.cdi.internal.Conventions;
import com.vaadin.data.util.converter.ConverterFactory;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Optional;
import javax.inject.Inject;
import org.linkki.core.ui.converters.LinkkiConverterFactory;
import org.linkki.framework.ui.application.ApplicationFooter;
import org.linkki.framework.ui.application.ApplicationHeader;
import org.linkki.framework.ui.application.CdiFixNavigator;
import org.linkki.util.StreamUtil;

@UIScoped
public class ApplicationFrame
implements Serializable {
    private static final long serialVersionUID = 1L;
    private VerticalLayout content;
    @Inject
    private ApplicationHeader header;
    private VerticalLayout mainArea;
    @Inject
    private ApplicationFooter footer;
    @Inject
    private CDIViewProvider viewProvider;
    private Navigator navigator;

    public void init(UI ui) {
        VaadinSession vaadinSession = VaadinSession.getCurrent();
        if (vaadinSession != null) {
            vaadinSession.setConverterFactory((ConverterFactory)new LinkkiConverterFactory());
        }
        this.content = new VerticalLayout();
        this.content.setMargin(false);
        this.content.setSizeFull();
        this.content.addComponent((Component)this.header);
        this.header.init();
        this.mainArea = new VerticalLayout();
        this.mainArea.setSizeFull();
        this.content.addComponent((Component)this.mainArea);
        this.content.setExpandRatio((Component)this.mainArea, 1.0f);
        this.content.addComponent((Component)this.footer);
        this.navigator = this.createNavigator(ui, (ComponentContainer)this.mainArea);
        this.navigator.addProvider(this.getViewProvider());
    }

    protected Navigator createNavigator(UI ui, ComponentContainer componentContainer) {
        return new CdiFixNavigator(ui, componentContainer);
    }

    protected VerticalLayout getMainArea() {
        return this.mainArea;
    }

    protected ViewProvider getViewProvider() {
        return this.viewProvider;
    }

    protected Navigator getNavigator() {
        return this.navigator;
    }

    public VerticalLayout getContent() {
        return this.content;
    }

    public <T extends View> void showView(Class<T> clazz) {
        this.showView(clazz, "");
    }

    public <T extends View> void showView(Class<T> clazz, String pathAndParameters) {
        String newViewName = Conventions.deriveMappingForView(clazz);
        String newFragment = newViewName + "/" + pathAndParameters;
        this.navigator.navigateTo(newFragment);
    }

    public Optional<Component> getCurrentView() {
        return StreamUtil.stream((Iterable)this.mainArea).findFirst();
    }

    public void refreshCurrentView() {
        this.getNavigator().navigateTo(this.getNavigator().getState());
    }
}

