/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui;

import org.apache.deltaspike.core.api.config.ConfigResolver;

public final class LinkkiStyles {
    public static final String MESSAGE_PREFIX = "linkki-message-";
    public static final String MESSAGE_LIST_STYLE = "linkki-message-list";
    public static final String SIDEBAR_LAYOUT = "linkki-sidebar-layout";
    public static final String SIDEBAR = "linkki-sidebar";
    public static final String SIDEBAR_SELECTED = "selected";
    public static final String SIDEBAR_CONTENT = "linkki-sidebar-content";
    public static final String THEME_NAME;
    public static final String STYLESHEET;
    public static final String ICON;
    private static final String FAVICON_ICO = "/favicon.ico";
    private static final String VAADIN_THEMES_PREFIX = "./VAADIN/themes/";
    private static final String STYLESHEET_KEY = "stylesheet";
    private static final String THEME_NAME_KEY = "theme";

    private LinkkiStyles() {
    }

    private static String buildIconPath(String theme) {
        return VAADIN_THEMES_PREFIX + theme + FAVICON_ICO;
    }

    private static String buildStylesheetPath(String theme) {
        return VAADIN_THEMES_PREFIX + theme + "/" + ConfigResolver.getPropertyValue((String)STYLESHEET_KEY, (String)"styles.css");
    }

    static {
        String themeName = ConfigResolver.getPropertyValue((String)THEME_NAME_KEY);
        if (themeName == null) {
            throw new RuntimeException("Wrong DeltaSpike configuration. Missed mandatory property 'theme'");
        }
        THEME_NAME = themeName;
        ICON = LinkkiStyles.buildIconPath(themeName);
        STYLESHEET = LinkkiStyles.buildStylesheetPath(themeName);
    }
}

