package org.linkedopenactors.rdfpub.client;

import java.io.IOException;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.util.Values;

import com.fasterxml.jackson.databind.ObjectMapper;

public class WebfingerParser {

	public static void main(String[] args) {
		WebfingerParser test = new WebfingerParser(); 
		System.out.println( test.doIt() );
	}

	
	public IRI doIt() {
		JsonResourceDescriptor jrd = parseJRD(getSample());
		Link l = jrd.getLinkByRel("self");
		return Values.iri(l.getHref().toString());
	}
	
	public JsonResourceDescriptor parseJRD(String json) {
        try {
            return new ObjectMapper().readValue(json, JsonResourceDescriptor.class);
        } catch (IOException e){
            throw new RuntimeException("ERROR_PARSING_JRD");
        }
    }
	
	private String getSample() {
		return "{\n"
				+ "    \"subject\": \"1813bdc1-152c-4c27-92a6-6cdfe401ef3d\",\n"
				+ "    \"links\": [\n"
				+ "        {\n"
				+ "            \"rel\": \"self\",\n"
				+ "            \"type\": \"application/activity+json\",\n"
				+ "            \"href\": \"http://localhost:8081/camel/1813bdc1-152c-4c27-92a6-6cdfe401ef3d\"\n"
				+ "        }\n"
				+ "    ]\n"
				+ "}";
	}
}
