package org.linkedopenactors.rdfpub.client;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.util.Models;
import org.linkedopenactors.ns.rdfpub.RDFPUB;

import de.naturzukunft.rdf4j.utils.ModelLogger;
import de.naturzukunft.rdf4j.vocabulary.AS;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class RdfPubServerProfileDefault implements RdfPubServerProfile {

	private Model model;
	private IRI subject;

	public RdfPubServerProfileDefault(Model model) {
		this.subject = model.stream()
				.findFirst()
				.map(stmt->stmt.getSubject())
				.map(IRI.class::cast)
				.orElseThrow(()->new IllegalStateException("could not determine subject of model " + ModelLogger.toString(model)));
		this.model = model;
	}
	
	@Override
	public IRI getPublicSparqlEndpoint() {
		return getProfileIri(RDFPUB.PUBLIC_SPARQL);
	}

	@Override
	public IRI getPublicCollectionEndpoint() {
		return getProfileIri(AS.Public);
	}

	private IRI getProfileIri(IRI predicate) {
		IRI object = Models.getPropertyIRI(model, subject, predicate).orElseThrow(()->{
			ModelLogger.error(log, model, "searching for '"+predicate+"' in Profile: ");
			return new RuntimeException("no '" + predicate + "' in profile of actor '" + subject + "'");
			});
		return object;
	}
}
