package org.linkedopenactors.rdfpub.client;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.query.BindingSet;

import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * The interface that describes the convinience methods for accessing a activity-pub client (C2S). 
 * @author <a href="http://hauschel.de">SofwareEngineering Hauschel</a>
 */
public interface RdfPubClientWebFlux {

	Mono<IRI> getActorId();
	Mono<org.linkedopenactors.rdfpub.domain.ActorProfile> getCurrentActorProfile();
	Mono<RdfPubServerProfile> getServerProfile();
	Mono<Model> read(IRI idOfTheResourceToRead);
	
	Flux<BindingSet> tupleQueryAsPublic(String query);
	Flux<BindingSet> tupleQueryOutbox(String query, String authToken);
	Flux<BindingSet> tupleQueryInbox(String query, String authToken);
	/**
	 * Posts a new activity to the usres outbox.
	 * @param activity the model of the new activity to post.
	 * @param token The Oauth2 accessToken to use.
	 * @return the id of the newly created activity.
	 */
	Mono<IRI> postActivity(Model activity, String token);
}
