package org.linkedopenactors.rdfpub.client;

import org.linkedopenactors.rdfpub.domain.ActorProfile;
import org.linkedopenactors.rdfpub.domain.DomainObjectFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.server.WebSession;

import reactor.core.publisher.Mono;

@Service
public class RdfPubClientSessionFactory {
	
	private static final String currentLoggedInActor = "currentLoggedInActor";
	private DomainObjectFactory domainObjectFactory;
	
	public RdfPubClientSessionFactory(DomainObjectFactory domainObjectFactory) {
		this.domainObjectFactory = domainObjectFactory;		
	}

	public Mono<RdfPubClientSession> getSession(RdfPubClientWebFlux rdfPubClientWebFlux, WebSession webSession) {
		return Mono.just(buildSession( rdfPubClientWebFlux, webSession));
	}
	
	private RdfPubClientSession buildSession(RdfPubClientWebFlux rdfPubClientWebFlux, WebSession webSession) {
		return new RdfPubClientSession() {			
			@Override
			public Mono<ActorProfile> getCurrentLoggedInActor() {
				if(hasCurrentLoggedInActor()) {
					return Mono.just((ActorProfile)webSession.getRequiredAttribute(currentLoggedInActor));
				} else {
					return rdfPubClientWebFlux.getCurrentActorProfile().map(p -> {
					org.linkedopenactors.rdfpub.domain.RdfObject rdfObject = domainObjectFactory.createRdfObject(p.asModel());
					 webSession.getAttributes().put(currentLoggedInActor, domainObjectFactory.createActorProfile(rdfObject));
					 return (ActorProfile)webSession.getRequiredAttribute(currentLoggedInActor);
					});
				}
			}
			@Override			
			public boolean hasCurrentLoggedInActor() {
				return webSession.getAttribute(currentLoggedInActor) != null;
			}	
		};
	}
}
