package org.linkedopenactors.rdfpub.client;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.query.BindingSet;

import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * The interface that describes the convinience methods for accessing a activity-pub client (C2S). 
 * @author <a href="http://hauschel.de">SofwareEngineering Hauschel</a>
 */
public interface RdfPubClientAnonymousWebFlux {
	Mono<RdfPubServerProfile> getServerProfile();
	Mono<Model> read(IRI idOfTheResourceToRead);
	Flux<BindingSet> tupleQueryAsPublic(String query);
}
