package org.linkedopenactors.rdfpub.client;

import java.util.Optional;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.springframework.web.reactive.function.client.WebClient;

import lombok.extern.slf4j.Slf4j;

/**
 * Default implementation of {@link RdfPubClient}.  
 * @author <a href="http://hauschel.de">SofwareEngineering Hauschel</a>
 */
@Slf4j
public class RdfPubClientAnonymousDefault extends RdfPubClientAbstract implements RdfPubClientAnonymous {
	
	/**
	 * @param webClient The webclient to use for http communication.
	 * @param rdfPubServerActorIri The iri/url of the server actor. Used to get the public sparql endpoint
	 */
	public RdfPubClientAnonymousDefault(IRI rdfPubServerActorIri, WebClient webClient) {
		super(rdfPubServerActorIri, webClient);
	}
	
	@Override
	public Optional<Model> read(IRI idOfTheResourceToRead) {
		log.trace("read(" + idOfTheResourceToRead + ")");
		return httpGetApString(idOfTheResourceToRead, null);
	}
}
