package org.linkedopenactors.rdfpub.client;

import java.util.List;
import java.util.Optional;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;

/**
 * The interface that describes the convinience methods for accessing a activity-pub client (C2S). 
 * @author <a href="http://hauschel.de">SofwareEngineering Hauschel</a>
 */
public interface RdfPubClient extends RdfPubClientAnonymous {

	Optional<Model> getProfile();
	Optional<Model> getProfile(String authToken);
	/**
	 * Posts a new activity to the usres outbox.
	 * @param activity the model of the new activity to post.
	 * @return the id of the newly created activity.
	 */
	IRI postActivity(Model activity, String token);
	Optional<Model> read(IRI idOfTheResourceToRead, String authToken);
	Model graphQueryOutbox(String query, String authToken);
	List<BindingSet> tupleQueryOutbox(String query, String authToken);
	IRI getActorId();
	Model getStatementsOutbox(String authToken, Resource subj, IRI pred, Value obj, Resource... contexts);
}
