/*
 * Decompiled with CFR 0.152.
 */
package org.lfenergy.shapeshifter.api.datetime;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import javax.xml.datatype.Duration;

public class DateTimeCalculation {
    private DateTimeCalculation() {
    }

    public static java.time.Duration toJavaTime(Duration duration) {
        if (!DateTimeCalculation.canBeConvertedWithoutOffset(duration)) {
            throw new IllegalArgumentException("Duration cannot be converted without offset because it contains months and/or years.");
        }
        return java.time.Duration.ofDays(duration.getDays()).plusHours(duration.getHours()).plusMinutes(duration.getMinutes()).plusSeconds(duration.getSeconds());
    }

    public static boolean canBeConvertedWithoutOffset(Duration duration) {
        return duration.getYears() == 0 && duration.getMonths() == 0;
    }

    public static ZoneId toZoneId(String ianaTimeZone) {
        return ZoneId.of(ianaTimeZone);
    }

    static ZonedDateTime toZonedDateTime(LocalDate pointInTime, String ianaTimeZone) {
        return pointInTime.atStartOfDay(DateTimeCalculation.toZoneId(ianaTimeZone));
    }

    public static ZonedDateTime startOfDay(ZonedDateTime pointInTime) {
        return pointInTime.with(ChronoField.NANO_OF_DAY, 0L);
    }

    public static java.time.Duration lengthOfDay(LocalDate onDay, String ianaTimeZone) {
        ZonedDateTime zonedDay = DateTimeCalculation.toZonedDateTime(onDay, ianaTimeZone);
        return java.time.Duration.between(zonedDay, zonedDay.plusDays(1L));
    }

    public static OffsetDateTime ispEndInDay(LocalDate onDay, String ianaTimeZone, long ofOneBasedIspIndex, java.time.Duration ispDuration) {
        java.time.Duration toAdd = ispDuration.multipliedBy(ofOneBasedIspIndex);
        return DateTimeCalculation.startOfDay(DateTimeCalculation.toZonedDateTime(onDay, ianaTimeZone)).plus(toAdd).toOffsetDateTime();
    }

    public static long numberOfIspsOnDay(LocalDate onDay, java.time.Duration ispDuration, String ianaTimeZone) {
        java.time.Duration durationOfDay = DateTimeCalculation.lengthOfDay(onDay, ianaTimeZone);
        return durationOfDay.toSeconds() / ispDuration.toSeconds();
    }
}

