/*
 * Decompiled with CFR 0.152.
 */
package org.lfenergy.shapeshifter.api;

public record EntityAddress(Scheme scheme, String address) {
    public static EntityAddress parse(String str) {
        if (str == null) {
            throw new IllegalArgumentException("Can not parse an Entity Address from null");
        }
        String[] parts = str.split("\\.", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Entity Address does not specify a scheme: " + str);
        }
        if (parts[1].isEmpty()) {
            throw new IllegalArgumentException("Entity Address has an empty address: " + str);
        }
        return new EntityAddress(Scheme.fromPrefix(parts[0]), parts[1]);
    }

    @Override
    public String toString() {
        return this.scheme.getPrefix() + "." + this.address;
    }

    public static enum Scheme {
        EAN("ean"),
        EA1("ea1");

        private final String prefix;

        private Scheme(String prefix) {
            this.prefix = prefix;
        }

        public static Scheme fromPrefix(String prefix) {
            for (Scheme scheme : Scheme.values()) {
                if (!scheme.prefix.equals(prefix)) continue;
                return scheme;
            }
            throw new IllegalArgumentException("Unsupported Entity Address scheme: " + prefix);
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

